import React, { FC } from 'react';

import { Story } from '@storybook/react';

import { createSlot, useSlots } from '..';
import { PageHeader } from '../../../components/Header';

interface HeaderProps {
  lang: string;
  tld: string;
}

const UserSlot = createSlot('user');

const PlusSlot = createSlot('plus');

const Header: FC<HeaderProps> = (props) => {
  const { tld, lang } = props;
  const slots = useSlots(props);

  const user = slots.get(UserSlot);
  const plus = slots.get(PlusSlot);

  return <PageHeader tld={tld} lang={lang} user={user?.rendered} plus={plus?.rendered} />;
};

const HeaderSlot = createSlot<HeaderProps>('header');

const Example: FC = (props) => {
  const slots = useSlots(props);
  const header = slots.get(HeaderSlot);

  return (
    <div>
      {header && <Header {...header.props} />}

      <main>{slots.children}</main>
    </div>
  );
};

export const NestedSlots: Story = () => {
  return (
    <Example>
      <HeaderSlot tld="ru" lang="ru">
        <UserSlot>User Content</UserSlot>
        <PlusSlot>Plus Content</PlusSlot>
      </HeaderSlot>

      <p>A paragraph for the main content.</p>
      <p>And another one.</p>
    </Example>
  );
};
