import React from 'react';

import { Story } from '@storybook/react';

import { Button, sizes, variants } from '../index';

export const Default: Story = (args) => {
  return <Button {...args}>Button</Button>;
};

Default.argTypes = {
  size: {
    defaultValue: 'm',
    control: {
      type: 'select',
    },
    options: sizes,
  },
  variant: {
    defaultValue: 'default',
    control: {
      type: 'select',
    },
    options: variants,
  },
  onPress: {
    action: 'onPress',
  },
};

Default.args = {
  disabled: false,
};
