import { component } from '../../libs/css-modules';
import { Button as UnstyledButton } from './Button';

import sizeL from './_size/size-l.module.css';
import sizeM from './_size/size-m.module.css';
import sizeXL from './_size/size-xl.module.css';
import sizeXXL from './_size/size-xxl.module.css';
import variantAction from './_variant/variant-action.module.css';
import variantClear from './_variant/variant-clear.module.css';
import variantDefault from './_variant/variant-default.module.css';
import variantOutline from './_variant/variant-outline.module.css';
import variantRaised from './_variant/variant-raised.module.css';
import variantText from './_variant/variant-text.module.css';

export const Button = component(UnstyledButton, {
  displayName: 'Button',
  defaultProps: {
    size: 'm',
    variant: 'default',
  },
  variants: {
    size: {
      m: sizeM.root,
      l: sizeL.root,
      xl: sizeXL.root,
      xxl: sizeXXL.root,
    },
    variant: {
      action: variantAction.root,
      clear: variantClear.root,
      default: variantDefault.root,
      outline: variantOutline.root,
      raised: variantRaised.root,
    },
  },
});

export const TextButton = component(UnstyledButton, {
  displayName: 'TextButton',
  styles: variantText.root,
  defaultProps: {
    size: 'm',
  },
  variants: {
    size: {
      m: sizeM.root,
      l: sizeL.root,
      xl: sizeXL.root,
      xxl: sizeXXL.root,
    },
  },
});

/**
 * @internal
 */
export const sizes = ['m', 'l', 'xl', 'xxl'] as const;

/**
 * @internal
 */
export const variants = ['action', 'default', 'outline', 'clear', 'raised'] as const;
