import React, { useState } from 'react';

import { Story } from '@storybook/react';

import { Checkbox } from '../index';

export const Default: Story = (args) => {
  const [isChecked, onChangeValue] = useState(false);

  return (
    <Checkbox checked={isChecked} onChangeValue={onChangeValue} {...args}>
      Checkbox label
    </Checkbox>
  );
};

Default.argTypes = {
  size: {
    defaultValue: 'm',
    control: {
      type: 'select',
    },
    options: ['s', 'm'],
  },
  variant: {
    defaultValue: 'default',
    control: {
      type: 'select',
    },
    options: ['default', 'outline'],
  },
};
