import React, { useState } from 'react';

import { Story } from '@storybook/react';

import { Checkbox } from '../index';

const sizes = ['s', 'm'] as const;

export const Sizes: Story = () => {
  const [isChecked, onChangeValue] = useState(false);

  return (
    <div style={{ display: 'flex', gap: 8 }}>
      {sizes.map((size) => (
        <Checkbox
          checked={isChecked}
          key={size}
          onChangeValue={onChangeValue}
          size={size}
          variant="default"
        >
          Checkbox size {size}
        </Checkbox>
      ))}
    </div>
  );
};
