import React, { useState } from 'react';

import { Story } from '@storybook/react';

import { Checkbox } from '../index';

const variants = ['default', 'outline'] as const;

export const Variants: Story = () => {
  const [isChecked, onChangeValue] = useState(false);

  return (
    <div style={{ display: 'flex', gap: 8 }}>
      {variants.map((variant) => (
        <Checkbox
          checked={isChecked}
          key={variant}
          onChangeValue={onChangeValue}
          size="m"
          variant={variant}
        >
          Checkbox variant {variant}
        </Checkbox>
      ))}
    </div>
  );
};
