import { ComponentProps } from 'react';

import { component } from '../../libs/css-modules';
import { Checkbox as UnstyledCheckbox } from './Checkbox';

import sizeM from './_size/size-m.module.css';
import sizeS from './_size/size-s.module.css';
import variantDefault from './_variant/variant-default.module.css';
import variantOutline from './_variant/variant-outline.module.css';

export const Checkbox = component(UnstyledCheckbox, {
  displayName: 'Checkbox',
  defaultProps: {
    size: 'm',
    variant: 'default',
  },
  variants: {
    size: {
      s: sizeS.root,
      m: sizeM.root,
    },
    variant: {
      default: variantDefault.root,
      outline: variantOutline.root,
    },
  },
});

export type CheckboxProps = ComponentProps<typeof Checkbox>;
