import classNames from 'classnames';
import React, { FC } from 'react';

import { PressEventProps } from '@use-platform/react';
import { CustomizableProps } from '@yandex-id/components/libs/css-modules';

import styles from './Icon.module.css';

export interface ButtonProps extends CustomizableProps, PressEventProps {}

export const Icon: FC<ButtonProps> = ({ className, ...otherProps }) => {
  return <span className={classNames(styles.root, className)} {...otherProps} />;
};
