import cx from 'classnames';
import 'focus-visible';
import React, { ChangeEventHandler, ReactNode } from 'react';

import { useUniqId } from '@use-platform/react';

import { CustomizableProps } from '../../libs/css-modules';

import styles from './RadioButton.module.css';

interface RadioButtonOption {
  children: ReactNode;
  value?: string;
}

export interface RadioButtonProps extends CustomizableProps {
  options: RadioButtonOption[];
  value?: string;
  disabled?: boolean;
  onChange?: ChangeEventHandler<HTMLInputElement>;
}

interface OptionProps extends RadioButtonOption {
  checked: boolean;
  id: string;
  onChange?: ChangeEventHandler<HTMLInputElement>;
}

const Option: React.FC<OptionProps> = ({ value, children, checked, onChange, id }) => {
  return (
    <>
      <input
        id={id}
        className={styles.input}
        type="radio"
        checked={checked}
        value={value}
        onChange={onChange}
      />
      <label htmlFor={id} className={cx(styles.option, { [styles.option_checked]: checked })}>
        {children}
      </label>
    </>
  );
};

export const RadioButton = (props: RadioButtonProps) => {
  const { className, value, options, onChange } = props;

  const uniqId = useUniqId();

  return (
    <span className={cx(styles.root, className)}>
      {options.map((option) => {
        const checked = value === option.value;
        const id = uniqId + option.value;

        return (
          <Option key={id} id={id} checked={checked} value={option.value} onChange={onChange}>
            {option.children}
          </Option>
        );
      })}
    </span>
  );
};
