import React, { useCallback, useState } from 'react';

import { Story } from '@storybook/react';

import { RadioButton, radioButtonSizes, radioButtonVariants } from '../index';

const options = [
  { value: 'option1', children: 'option1' },
  { value: 'option2', children: 'option2' },
  { value: 'option3', children: 'option3' },
];

export const Default: Story = (args) => {
  const [value, setValue] = useState('option1');
  const onChange = useCallback((e) => {
    setValue(e.target.value);
  }, []);

  return <RadioButton {...args} options={options} value={value} onChange={onChange} />;
};

Default.argTypes = {
  size: {
    defaultValue: 'm',
    control: {
      type: 'select',
    },
    options: radioButtonSizes,
  },
  variant: {
    defaultValue: 'default',
    control: {
      type: 'select',
    },
    options: radioButtonVariants,
  },
};

Default.args = {
  disabled: false,
};
