import { component } from '../../libs/css-modules';
import { RadioButton as UnstyledRadioButtonButton } from './RadioButton';

import sizeL from './_size/size-l.module.css';
import sizeM from './_size/size-m.module.css';
import sizeS from './_size/size-s.module.css';
import sizeXL from './_size/size-xl.module.css';
import variantDefault from './_variant/variant-default.module.css';
import variantOutline from './_variant/variant-outline.module.css';

export const RadioButton = component(UnstyledRadioButtonButton, {
  displayName: 'RadioButton',
  defaultProps: {
    size: 'm',
    variant: 'default',
  },
  variants: {
    size: {
      s: sizeS.root,
      m: sizeM.root,
      l: sizeL.root,
      xl: sizeXL.root,
    },
    variant: {
      default: variantDefault.root,
      outline: variantOutline.root,
    },
  },
});

/**
 * @internal
 */
export const radioButtonSizes = ['s', 'm', 'l', 'xl'] as const;

/**
 * @internal
 */
export const radioButtonVariants = ['default', 'outline'] as const;
