import { ElementType, HTMLAttributes, PropsWithoutRef, RefAttributes } from 'react';

export type InferElement<T extends ElementType> = T extends keyof JSX.IntrinsicElements
  ? JSX.IntrinsicElements[T] extends HTMLAttributes<infer P>
    ? P
    : HTMLElement
  : HTMLElement;

export type ElementTypeProps<T extends ElementType, P = {}> = PropsWithoutRef<P> &
  RefAttributes<InferElement<T>>;
