import { useCallback, useEffect, useState } from 'react';

export const useFetch = <T>(getData: Promise<T>) => {
  const [shouldLoadData, setShouldLoadData] = useState(true);
  const [data, setData] = useState<T | null>(null);
  const [isLoading, setLoading] = useState(true);
  const [loadingError, setLoadingError] = useState<Error | null>(null);

  const loadData = useCallback(async () => {
    setShouldLoadData(false);

    try {
      const rawData = await getData;

      setData(rawData);
    } catch (error) {
      setLoadingError(error as Error);
    } finally {
      setLoading(false);
    }
  }, [getData]);

  useEffect(() => {
    if (shouldLoadData) {
      loadData();
    }
  }, [shouldLoadData, loadData]);

  return {
    data,
    isLoading,
    loadingError,
  };
};
