import { useEffect, useState } from 'react';

import { canUseDOM } from '@yandex-lego/components/lib/canUseDOM';

export const useMatchMedia = (query: string) => {
  const [matches, setMatches] = useState(() => {
    // TODO: непонятно как это должно при SSR работать
    return canUseDOM() ? window.matchMedia(query).matches : null;
  });

  useEffect(() => {
    const mediaQuery = window.matchMedia(query);

    function onChange(event: MediaQueryListEvent) {
      setMatches(event.matches);
    }

    if (mediaQuery.addEventListener) {
      mediaQuery.addEventListener('change', onChange);
    } else {
      // IE fallback
      mediaQuery.addListener(onChange);
    }

    return () => {
      if (mediaQuery.removeEventListener) {
        mediaQuery.removeEventListener('change', onChange);
      } else {
        // IE fallback
        mediaQuery.removeListener(onChange);
      }
    };
  }, [query]);

  return matches;
};
