import React, { FC } from 'react';

import { ThemeProvider, ThemeValue } from '@yandex-id/design-system';

import { SSRProvider } from './SSRProvider';

export const Provider: FC<ThemeValue> = (props) => {
  const { children, colorScheme, theme } = props;

  return (
    <SSRProvider>
      <ThemeProvider colorScheme={colorScheme} theme={theme}>
        {children}
      </ThemeProvider>
    </SSRProvider>
  );
};
