import React, { FC } from 'react';
import { SSRProvider as AriaSSRProvider } from 'react-aria';

import { SSRProvider as PlatformSSRProvider } from '@use-platform/react';

export const SSRProvider: FC = (props) => {
  const { children } = props;

  return (
    <AriaSSRProvider>
      <PlatformSSRProvider>{children}</PlatformSSRProvider>
    </AriaSSRProvider>
  );
};
