import { context, createResponseComposition, rest, setupWorker } from 'msw';
import type { RequestHandler, SetupWorkerApi } from 'msw';

import { paths } from './paths';
import searchMock from './search.mock';
import suggestMock from './suggest.mock';

const server = { value: null as SetupWorkerApi | null };

export function startFakeServer() {
  const baseUrl = document.location.pathname.replace(/\/(index|iframe)\.html/, '');
  const serviceWorkerUrl = `${baseUrl}/mock-service-worker.js`;

  // eslint-disable-next-line @typescript-eslint/no-use-before-define
  server.value = setupWorker(...handlers);
  server.value.start({
    serviceWorker: {
      url: serviceWorkerUrl,
    },
  });
}

export function stopFakeServer() {
  server.value?.stop();
}

const delayedResponse = createResponseComposition(undefined, [context.delay('real')]);

const handlers: RequestHandler[] = [
  rest.get(paths.suggest, (_req, res, ctx) => {
    return res(ctx.status(200), ctx.json(suggestMock));
  }),
  rest.get(paths.search, (req, res, ctx) => {
    const text = req.url.searchParams.get('text');

    if (text === 'qwerty') {
      return res(ctx.status(200), ctx.json({ results: [] }));
    }

    if (text === 'broken') {
      return res(ctx.status(500));
    }

    return delayedResponse(ctx.status(200), ctx.json(searchMock));
  }),
];
