import type {
  NormalizedSuggestItem,
  NormalizedSuggestSection,
  SearchResponse,
  SourceItem,
} from './types';

export function responseAdapter(data: SearchResponse): NormalizedSuggestSection[] {
  const result = [];
  const sources = getSources();

  for (const _section of data.results) {
    if (!sources[_section.source]) {
      continue;
    }

    const section: NormalizedSuggestSection = {
      items: [],
      source: sources[_section.source],
      searchUrl: _section.search_url ?? undefined,
    };

    for (const _item of _section.results) {
      const item: NormalizedSuggestItem = {
        date: getDate(_item),
        description: getDescription(_item),
        id: _item.id,
        scope: _item.scope,
        searchUrl: _item.resource_url,
        source: _item.source,
        title: _item.name,
      };

      if (_item.cashback_amount) {
        item.payment = {
          amount: _item.amount,
          currency: _item.currency,
          cashbackAmount: _item.cashback_amount,
        };
      }

      section.items.push(item);
    }

    if (section.items.length > 0) {
      result.push(section);
    }
  }

  return result;
}

function getSources() {
  const sources: Record<string, string> = {
    passport: 'ID',
    disk: 'Диск',
    mail: 'Почта',
    suggest: 'Часто ищут',
  };

  return sources;
}

function getDate(item: SourceItem) {
  if (item.source === 'disk' && item.scope === 'folder') {
    return null;
  }

  return item.date ?? null;
}

function getDescription(item: SourceItem) {
  if (item.source === 'disk' && item.scope === 'folder') {
    return 'Папка';
  }

  if (item.source === 'mail') {
    return item.firstline;
  }

  return undefined;
}
