/* eslint-disable camelcase */

export interface SearchResponse {
  results: Source[];
}

export interface Source {
  results: SourceItem[];
  search_url: string | null;
  source: string;
}

export interface SourceItem {
  amount: string;
  cashback_amount: string;
  currency: string;
  date?: number;
  id: string;
  name: string;
  resource_url: string;
  snippet: string;
  source: string;
  scope?: string;
  firstline?: string;
}

export interface NormalizedSuggestSection {
  items: NormalizedSuggestItem[];
  source: string;
  searchUrl?: string;
}

export interface NormalizedSuggestItem {
  date: number | null;
  description?: string;
  id: string;
  searchUrl: string;
  source: string;
  scope?: string;
  title: string;
  payment?: {
    amount: string;
    currency: string;
    cashbackAmount: string;
  };
}
