import React, { FC } from 'react';

interface FileProps {
  size?: 12 | 16 | 24 | 32;
}

export const File: FC<FileProps> = (props) => {
  const { size } = props;

  return (
    <svg width={size} height={size} viewBox="0 0 16 16" fill="none" focusable={false} aria-hidden>
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M5.46982 1.33325H7.99404C8.51046 1.33325 8.6891 1.35195 8.88709 1.39758C9.08508 1.44321 9.26027 1.51578 9.43254 1.62352C9.60481 1.73125 9.74434 1.84434 10.1095 2.20951L11.7903 3.89033C12.1555 4.25549 12.2686 4.39503 12.3763 4.5673C12.4841 4.73957 12.5566 4.91476 12.6023 5.11275C12.6479 5.31074 12.6666 5.48938 12.6666 6.00579V12.53C12.6666 13.2729 12.5892 13.5424 12.444 13.814C12.2987 14.0856 12.0856 14.2987 11.814 14.444C11.5424 14.5892 11.2729 14.6666 10.53 14.6666H5.46982C4.72689 14.6666 4.45749 14.5892 4.18588 14.444C3.91428 14.2987 3.70112 14.0856 3.55586 13.814C3.41061 13.5424 3.33325 13.2729 3.33325 12.53V3.46982C3.33325 2.72689 3.41061 2.45749 3.55586 2.18588C3.70112 1.91428 3.91428 1.70112 4.18588 1.55586C4.45749 1.41061 4.72689 1.33325 5.46982 1.33325ZM5.46982 2.66659C5.18555 2.66659 5.00742 2.67924 4.90391 2.69923C4.86336 2.70706 4.85441 2.71037 4.81468 2.73161C4.77543 2.7526 4.7526 2.77543 4.73161 2.81468C4.71037 2.85441 4.70706 2.86336 4.69923 2.90391C4.67924 3.00742 4.66659 3.18555 4.66659 3.46982V12.53C4.66659 12.8143 4.67924 12.9924 4.69923 13.0959C4.70706 13.1365 4.71037 13.1454 4.73161 13.1852C4.7526 13.2244 4.77543 13.2472 4.81468 13.2682C4.85441 13.2895 4.86336 13.2928 4.90391 13.3006C5.00742 13.3206 5.18555 13.3333 5.46982 13.3333H10.53C10.8143 13.3333 10.9924 13.3206 11.0959 13.3006C11.1365 13.2928 11.1454 13.2895 11.1852 13.2682C11.2244 13.2472 11.2472 13.2244 11.2682 13.1852C11.2895 13.1454 11.2928 13.1365 11.3006 13.0959C11.3206 12.9924 11.3333 12.8143 11.3333 12.53V6.66658H9.46982C8.72689 6.66658 8.45749 6.58923 8.18588 6.44397C7.91428 6.29872 7.70112 6.08556 7.55586 5.81396C7.41061 5.54235 7.33325 5.27295 7.33325 4.53001V2.66659H5.46982ZM8.66659 2.72225V4.53001C8.66659 4.81429 8.67924 4.99242 8.69923 5.09593C8.70706 5.13647 8.71037 5.14543 8.73161 5.18516C8.7526 5.22441 8.77543 5.24723 8.81468 5.26822C8.85441 5.28947 8.86336 5.29277 8.90391 5.3006C9.00742 5.32059 9.18555 5.33325 9.46982 5.33325H11.2776C11.2691 5.31393 11.2588 5.29502 11.2459 5.27428C11.1935 5.19055 11.1254 5.11099 10.8475 4.83314L9.1667 3.15231C8.88885 2.87447 8.80928 2.80634 8.72556 2.75398C8.70482 2.74101 8.6859 2.73074 8.66659 2.72225Z"
        fill="currentColor"
      />
    </svg>
  );
};
