import React, { FC } from 'react';

interface FolderProps {
  size?: 12 | 16 | 24 | 32;
}

export const Folder: FC<FolderProps> = (props) => {
  const { size } = props;

  return (
    <svg width={size} height={size} viewBox="0 0 16 16" fill="none" focusable={false} aria-hidden>
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M5.14856 2H3.46982C2.72689 2 2.45749 2.07735 2.18588 2.22261C1.91428 2.36787 1.70112 2.58102 1.55586 2.85263C1.41061 3.12423 1.33325 3.39364 1.33325 4.13657V10.5301C1.33325 11.273 1.41061 11.5424 1.55586 11.814C1.70112 12.0856 1.91428 12.2988 2.18588 12.4441C2.45749 12.5893 2.72689 12.6667 3.46982 12.6667H12.53C13.2729 12.6667 13.5424 12.5893 13.814 12.4441C14.0856 12.2988 14.2987 12.0856 14.444 11.814C14.5892 11.5424 14.6666 11.273 14.6666 10.5301V6.13657C14.6666 5.39364 14.5892 5.12423 14.444 4.85263C14.2987 4.58102 14.0856 4.36787 13.814 4.22261C13.5424 4.07735 13.2729 4 12.53 4H7.99992L7.50863 3.26307C7.17207 2.75822 7.02604 2.59613 6.83663 2.43953C6.64722 2.28294 6.4419 2.17306 6.20655 2.10232C5.97119 2.03159 5.75532 2 5.14856 2ZM2.90391 3.36598C3.00742 3.34599 3.18555 3.33333 3.46982 3.33333H5.14856C5.59433 3.33333 5.71079 3.34558 5.82278 3.37923C5.88779 3.39877 5.93473 3.42389 5.98705 3.46715C6.07718 3.54166 6.15196 3.63177 6.39923 4.00267L6.89052 4.7396C7.13781 5.11053 7.55411 5.33333 7.99992 5.33333H12.53C12.8143 5.33333 12.9924 5.34599 13.0959 5.36598C13.1365 5.37381 13.1454 5.37711 13.1852 5.39836C13.2244 5.41935 13.2472 5.44218 13.2682 5.48143C13.2895 5.52116 13.2928 5.53011 13.3006 5.57066C13.3206 5.67417 13.3333 5.85229 13.3333 6.13657V10.5301C13.3333 10.8144 13.3206 10.9925 13.3006 11.096C13.2928 11.1366 13.2895 11.1455 13.2682 11.1852C13.2472 11.2245 13.2244 11.2473 13.1852 11.2683C13.1454 11.2896 13.1365 11.2929 13.0959 11.3007C12.9924 11.3207 12.8143 11.3333 12.53 11.3333H3.46982C3.18555 11.3333 3.00742 11.3207 2.90391 11.3007C2.86336 11.2929 2.85441 11.2896 2.81468 11.2683C2.77543 11.2473 2.7526 11.2245 2.73161 11.1852C2.71037 11.1455 2.70706 11.1366 2.69923 11.096C2.67924 10.9925 2.66659 10.8144 2.66659 10.5301V4.13657C2.66659 3.85229 2.67924 3.67417 2.69923 3.57066C2.70706 3.53011 2.71037 3.52116 2.73161 3.48143C2.7526 3.44218 2.77543 3.41935 2.81468 3.39836C2.85441 3.37711 2.86336 3.37381 2.90391 3.36598Z"
        fill="currentColor"
      />
    </svg>
  );
};
