import React, { FC } from 'react';

interface IdProps {
  size?: 12 | 16 | 24 | 32;
}

export const Id: FC<IdProps> = (props) => {
  const { size } = props;

  return (
    <svg width={size} height={size} viewBox="0 0 16 16" fill="none" focusable={false} aria-hidden>
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M8.73984 1.37397C8.37387 1.33351 8.04441 1.59739 8.00396 1.96335C7.9635 2.32931 8.22737 2.65877 8.59334 2.69923C10.4803 2.90783 12.0731 4.10262 12.8413 5.75921C12.9962 6.09323 13.3925 6.23845 13.7265 6.08356C14.0606 5.92867 14.2058 5.53232 14.0509 5.1983C13.0919 3.13026 11.1033 1.63523 8.73984 1.37397ZM5.80877 3.13592C6.14437 2.98447 6.29366 2.58964 6.14221 2.25404C5.99077 1.91844 5.59594 1.76915 5.26033 1.9206C2.94611 2.96494 1.33325 5.29339 1.33325 7.99998C1.33325 11.6819 4.31802 14.6666 7.99992 14.6666C11.4319 14.6666 14.2574 12.0739 14.6259 8.7399C14.6664 8.37394 14.4025 8.04447 14.0366 8.00402C13.6706 7.96356 13.3411 8.22744 13.3007 8.5934C13.006 11.2593 10.7447 13.3333 7.99992 13.3333C5.0544 13.3333 2.66659 10.9455 2.66659 7.99998C2.66659 5.83656 3.95477 3.97257 5.80877 3.13592ZM5.86625 9.59985C5.64508 9.30549 5.22717 9.24615 4.9328 9.46731C4.63843 9.68847 4.57909 10.1064 4.80025 10.4008C5.52891 11.3706 6.69101 12 7.99992 12C9.30883 12 10.4709 11.3706 11.1996 10.4008C11.4207 10.1064 11.3614 9.68847 11.067 9.46731C10.7727 9.24615 10.3548 9.30549 10.1336 9.59985C9.64594 10.2489 8.87181 10.6666 7.99992 10.6666C7.12803 10.6666 6.3539 10.2489 5.86625 9.59985Z"
        fill="currentColor"
      />
    </svg>
  );
};
