import React, { FC } from 'react';

interface KeyProps {
  size?: 12 | 16 | 24 | 32;
}

export const Key: FC<KeyProps> = (props) => {
  const { size } = props;

  return (
    <svg width={size} height={size} viewBox="0 0 16 16" fill="none" focusable={false} aria-hidden>
      <path
        d="M7 3.99931C6.63181 3.99931 6.33334 4.29779 6.33334 4.66598C6.33334 5.03416 6.63181 5.33264 7 5.33264H9C9.36819 5.33264 9.66667 5.03416 9.66667 4.66598C9.66667 4.29779 9.36819 3.99931 9 3.99931H7Z"
        fill="currentColor"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M5.66667 9.30925C4.48134 9.15147 3.52661 8.21226 3.37467 6.99673L3.04133 4.33007C2.84238 2.73846 4.08341 1.33264 5.68741 1.33264H10.3126C11.9166 1.33264 13.1576 2.73846 12.9586 4.33007L12.6253 6.99673C12.4734 8.21225 11.5187 9.15145 10.3333 9.30924V14.1104L8 15.3326L5.66667 14.1104V9.30925ZM5.68741 2.66597H10.3126C11.1146 2.66597 11.7351 3.36888 11.6356 4.16469L11.3023 6.83135C11.2189 7.49859 10.6517 7.99931 9.97924 7.99931H9.66667C9.29848 7.99931 9 8.29778 9 8.66598V13.3037L8 13.8275L7 13.3037V8.66598C7 8.29778 6.70153 7.99931 6.33334 7.99931H6.02074C5.34831 7.99931 4.78111 7.49859 4.6977 6.83135L4.36437 4.16469C4.26489 3.36888 4.88541 2.66597 5.68741 2.66597Z"
        fill="currentColor"
      />
    </svg>
  );
};
