import React, { FC } from 'react';

interface LoginProps {
  size?: 12 | 16 | 24 | 32;
}

export const Login: FC<LoginProps> = (props) => {
  const { size } = props;

  return (
    <svg width={size} height={size} viewBox="0 0 16 16" fill="none" focusable={false} aria-hidden>
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M8.73352 1.33674L8.07021 1.2699L7.93652 2.59651L8.59983 2.66336C10.2604 2.83071 11.699 3.78534 12.5425 5.1632L12.8906 5.73178L14.0278 5.03563L13.6797 4.46705C12.6289 2.75059 10.828 1.54782 8.73352 1.33674ZM5.97398 3.08027L6.5834 2.81L6.04287 1.59115L5.43344 1.86141C4.38223 2.3276 3.47588 3.0626 2.7975 3.97907C2.57844 4.27501 2.64077 4.69249 2.9367 4.91155C3.23264 5.1306 3.65012 5.06828 3.86918 4.77234C4.41302 4.03764 5.13777 3.4511 5.97398 3.08027ZM14.6667 7.9852V7.31853H13.3333V7.9852C13.3333 10.9483 10.9694 13.3334 8.07408 13.3334C6.35822 13.3334 4.8315 12.4981 3.86918 11.1981C3.65012 10.9021 3.23264 10.8398 2.9367 11.0589C2.64077 11.2779 2.57844 11.6954 2.7975 11.9913C3.99749 13.6125 5.91296 14.6667 8.07408 14.6667C11.7244 14.6667 14.6667 11.6659 14.6667 7.9852ZM10.0436 6.94194C10.6269 7.52732 10.6268 8.47378 10.0433 9.05904C9.37641 9.72799 8.61446 10.4922 8.47327 10.6334C8.21327 10.8934 7.7866 10.8934 7.5266 10.6334C7.2666 10.3734 7.2666 9.95338 7.5266 9.69338C7.86701 9.35297 8.24449 9.05172 8.65265 8.79644L8.91068 8.63505L8.74598 8.47151C8.09854 8.60154 7.43899 8.66728 6.77696 8.66728H1.99841C1.63022 8.66728 1.33174 8.3688 1.33174 8.00061C1.33174 7.63242 1.63022 7.33394 1.99841 7.33394H6.77696C7.43899 7.33394 8.09854 7.39968 8.74598 7.52971L8.91068 7.36617L8.65332 7.2052C8.24475 6.94966 7.86737 6.64747 7.5266 6.30671C7.2666 6.04671 7.2666 5.62671 7.5266 5.36671C7.7866 5.10671 8.21327 5.10671 8.47327 5.36671C8.61448 5.50792 9.3766 6.27262 10.0436 6.94194Z"
        fill="currentColor"
      />
    </svg>
  );
};
