import React, { FC } from 'react';

interface MailProps {
  size?: 12 | 16 | 24 | 32;
}

export const Mail: FC<MailProps> = (props) => {
  const { size } = props;

  return (
    <svg width={size} height={size} viewBox="0 0 16 16" fill="none" focusable={false} aria-hidden>
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M3.46982 3.33325H12.53C13.2729 3.33325 13.5424 3.41061 13.814 3.55586C14.0856 3.70112 14.2987 3.91428 14.444 4.18588C14.5892 4.45749 14.6666 4.72689 14.6666 5.46982V10.53C14.6666 11.2729 14.5892 11.5424 14.444 11.814C14.2987 12.0856 14.0856 12.2987 13.814 12.444C13.5424 12.5892 13.2729 12.6666 12.53 12.6666H3.46982C2.72689 12.6666 2.45749 12.5892 2.18588 12.444C1.91428 12.2987 1.70112 12.0856 1.55586 11.814C1.41061 11.5424 1.33325 11.2729 1.33325 10.53V5.46982C1.33325 4.72689 1.41061 4.45749 1.55586 4.18588C1.70112 3.91428 1.91428 3.70112 2.18588 3.55586C2.45749 3.41061 2.72689 3.33325 3.46982 3.33325ZM2.66659 6.33325L2.57009 5.17536L2.6262 5.13795L3.3317 5.75356L7.04009 8.36591C7.61573 8.77142 8.38411 8.77142 8.95975 8.36591L12.6651 5.75569L13.3735 5.13784L13.4297 5.17536L13.3333 6.33325V10.53C13.3333 10.8143 13.3206 10.9924 13.3006 11.0959C13.2928 11.1365 13.2895 11.1454 13.2682 11.1852C13.2472 11.2244 13.2244 11.2472 13.1852 11.2682C13.1454 11.2895 13.1365 11.2928 13.0959 11.3006C12.9924 11.3206 12.8143 11.3333 12.53 11.3333H3.46982C3.18555 11.3333 3.00742 11.3206 2.90391 11.3006C2.86336 11.2928 2.85441 11.2895 2.81468 11.2682C2.77543 11.2472 2.7526 11.2244 2.73161 11.1852C2.71037 11.1454 2.70706 11.1365 2.69923 11.0959C2.67924 10.9924 2.66659 10.8143 2.66659 10.53V6.33325ZM12.3666 4.46659L10.6666 4.66659H5.33325L3.63325 4.46659L3.53309 4.53336C4.1768 4.80828 4.79068 5.15038 5.36435 5.5545L7.80795 7.27588C7.92308 7.35698 8.07676 7.35698 8.19188 7.27588L10.632 5.55693C11.207 5.1519 11.8224 4.80917 12.4676 4.53394L12.3666 4.46659Z"
        fill="currentColor"
      />
    </svg>
  );
};
