import React, { FC } from 'react';

interface PassportProps {
  size?: 12 | 16 | 24 | 32;
}

export const Passport: FC<PassportProps> = (props) => {
  const { size } = props;

  return (
    <svg width={size} height={size} viewBox="0 0 16 16" fill="none" focusable={false} aria-hidden>
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M8.00012 2.86987C8.55241 2.86987 9.00012 2.42216 9.00012 1.86987C9.00012 1.31759 8.55241 0.869873 8.00012 0.869873C7.44784 0.869873 7.00012 1.31759 7.00012 1.86987C7.00012 2.42216 7.44784 2.86987 8.00012 2.86987ZM7.99903 15.666L7.99972 15.6666L8.00045 15.6661C8.18955 15.4776 8.56615 15.3958 9.00803 15.2997C9.86844 15.1127 10.9784 14.8715 11.445 13.6831C11.5407 13.4393 11.6093 13.1557 11.6431 12.8245C11.6588 12.6712 11.667 12.5078 11.667 12.3334C11.3371 12.3627 11.0613 12.3596 10.8308 12.3334C10.6746 12.3157 10.5393 12.2874 10.422 12.2514C10.3292 12.2229 10.2478 12.1896 10.1762 12.1529C9.59704 11.8555 9.66665 11.3337 9.66665 11.3337C9.66665 10.6062 10.6667 10.6937 10.6667 11.3337C10.7779 11.3633 10.8873 11.3887 10.9949 11.4099L10.9978 11.4105C11.2025 11.4508 11.4007 11.4761 11.5921 11.4875C11.9616 11.5096 12.3063 11.48 12.6254 11.4065C15.9571 10.6392 16.5114 5.08919 13.6666 3.66676L10.6666 6.66676C10.3332 7.00009 9.41731 6.76594 9.4809 6.24344C9.67665 4.63482 10.7938 4.40246 10.9999 4.99961C11.4258 4.82552 11.6164 4.35977 11.4829 3.96482C11.3927 3.69789 11.1544 3.46331 10.7408 3.37296C10.7047 3.36508 10.6673 3.35829 10.6285 3.35268C10.5418 3.34013 10.4484 3.33345 10.348 3.33345L10.2168 3.33344C9.88757 3.33338 9.63623 3.33279 9.43938 3.32735C9.24002 3.32183 9.09654 3.31134 8.98461 3.29136C8.95323 3.28576 8.92432 3.27942 8.89737 3.27223C8.88406 3.27937 8.88119 3.29339 8.88673 3.3121C8.89723 3.34756 8.93792 3.39987 8.99496 3.45412C9.08498 3.53976 9.21572 3.63024 9.33274 3.66698C9.28188 3.71412 9.23295 3.76183 9.18588 3.80999C8.14679 4.87312 8.01393 6.15436 8.00104 6.31651C8.04703 8.08623 10.3755 8.84344 11.6094 7.60957L13.7389 5.48004C13.8567 5.66485 13.9546 5.88228 14.0283 6.13233C14.2172 6.77321 14.2158 7.5447 14.0106 8.25508C13.8051 8.96646 13.4268 9.51597 12.9653 9.82884C12.6342 10.0533 12.1886 10.2065 11.5784 10.1497C11.2229 9.73324 10.6977 9.50948 10.2249 9.4888C9.80686 9.47052 9.32447 9.59269 8.93257 9.94425C8.53683 10.2992 8.3497 10.7833 8.33435 11.2683C8.33231 11.301 8.33088 11.3381 8.33072 11.3792C8.33034 11.4769 8.33708 11.6018 8.36184 11.7446C8.41163 12.0317 8.53806 12.4082 8.83646 12.7632C9.13806 13.122 9.53106 13.3685 9.99836 13.5161C9.97498 13.5387 9.95284 13.5572 9.93295 13.5728C9.68753 13.7658 9.33321 13.8646 8.72484 13.9968L8.69608 14.0031C8.49744 14.0462 8.23682 14.1027 7.99988 14.1794C7.7629 14.1027 7.50227 14.0462 7.30359 14.003L7.27497 13.9968C6.6666 13.8646 6.31228 13.7657 6.06686 13.5728C6.04697 13.5572 6.02483 13.5387 6.00145 13.5161C6.46875 13.3685 6.86176 13.1219 7.16335 12.7631C7.46175 12.4081 7.58818 12.0317 7.63797 11.7446C7.66274 11.6017 7.66948 11.4769 7.66909 11.3792C7.66893 11.3381 7.6675 11.301 7.66546 11.2683C7.65011 10.7833 7.46298 10.2992 7.06725 9.94424C6.67534 9.59268 6.19295 9.47051 5.77491 9.48879C5.3021 9.50946 4.77696 9.73323 4.42138 10.1497C3.81117 10.2065 3.36558 10.0533 3.0345 9.82883C2.57299 9.51596 2.1947 8.96645 1.9892 8.25507C1.78398 7.54469 1.78262 6.77319 1.97155 6.13232C2.04526 5.88227 2.14313 5.66484 2.26092 5.48003L4.39044 7.60956C5.6249 8.84401 7.95324 8.08557 7.99869 6.3154C7.98529 6.14863 7.85071 4.87074 6.81393 3.80997C6.76686 3.76182 6.71793 3.71411 6.66708 3.66697C6.78409 3.63023 6.91483 3.53975 7.00485 3.45411C7.06189 3.39986 7.10258 3.34755 7.11308 3.31208C7.11862 3.29338 7.11575 3.27936 7.10245 3.27222C7.07549 3.27941 7.04659 3.28575 7.01521 3.29135C6.90328 3.31133 6.7598 3.32182 6.56043 3.32734C6.36358 3.33278 6.11225 3.33336 5.78301 3.33343L5.65181 3.33344C5.55142 3.33344 5.45799 3.34012 5.37132 3.35267C5.33253 3.35828 5.2951 3.36507 5.25901 3.37295C4.8454 3.4633 4.60716 3.69788 4.51693 3.96481C4.38343 4.35976 4.57397 4.82551 4.99992 4.9996C5.20601 4.40245 6.32316 4.63481 6.51891 6.24343C6.5825 6.76593 5.66659 7.00008 5.33325 6.66675L2.33325 3.66675C-0.511604 5.08918 0.0426873 10.6391 3.37442 11.4065C3.69355 11.48 4.03817 11.5096 4.40772 11.4875C4.59916 11.4761 4.79729 11.4508 5.00204 11.4105L5.00493 11.4099C5.11251 11.3887 5.22193 11.3633 5.33316 11.3336C5.33316 10.6936 6.33316 10.6062 6.33316 11.3336C6.33316 11.3336 6.40277 11.8555 5.82359 12.1528C5.75204 12.1896 5.67057 12.2229 5.57785 12.2514C5.46052 12.2874 5.32517 12.3157 5.16904 12.3334C4.93853 12.3596 4.66274 12.3626 4.33283 12.3334C4.33283 12.5078 4.34104 12.6712 4.3567 12.8245C4.39054 13.1556 4.45916 13.4393 4.55485 13.683C5.02138 14.8715 6.13137 15.1127 6.99178 15.2997C7.43372 15.3958 7.80981 15.4775 7.99903 15.666Z"
        fill="currentColor"
      />
    </svg>
  );
};
