import React, { FC } from 'react';

interface PhoneProps {
  size?: 12 | 16 | 24 | 32;
}

export const Phone: FC<PhoneProps> = (props) => {
  const { size } = props;

  return (
    <svg width={size} height={size} viewBox="0 0 24 24" fill="none" focusable={false} aria-hidden>
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M6 6.8C6 5.11984 6 4.27976 6.32698 3.63803C6.6146 3.07354 7.07354 2.6146 7.63803 2.32698C8.27976 2 9.11984 2 10.8 2H13.2C14.8802 2 15.7202 2 16.362 2.32698C16.9265 2.6146 17.3854 3.07354 17.673 3.63803C18 4.27976 18 5.11984 18 6.8V17.2C18 18.8802 18 19.7202 17.673 20.362C17.3854 20.9265 16.9265 21.3854 16.362 21.673C15.7202 22 14.8802 22 13.2 22H10.8C9.11984 22 8.27976 22 7.63803 21.673C7.07354 21.3854 6.6146 20.9265 6.32698 20.362C6 19.7202 6 18.8802 6 17.2V6.8ZM8 5.70527C8 5.14521 8 4.86518 8.10899 4.65127C8.20487 4.46311 8.35785 4.31013 8.54601 4.21426C8.75992 4.10526 9.03995 4.10526 9.6 4.10526H14.4C14.9601 4.10526 15.2401 4.10526 15.454 4.21426C15.6422 4.31013 15.7951 4.46311 15.891 4.65127C16 4.86518 16 5.14521 16 5.70526V18.2947C16 18.8548 16 19.1348 15.891 19.3487C15.7951 19.5369 15.6422 19.6899 15.454 19.7857C15.2401 19.8947 14.9601 19.8947 14.4 19.8947H9.6C9.03995 19.8947 8.75992 19.8947 8.54601 19.7857C8.35785 19.6899 8.20487 19.5369 8.10899 19.3487C8 19.1348 8 18.8548 8 18.2947V5.70527ZM10.5 17C9.94772 17 9.5 17.4477 9.5 18C9.5 18.5523 9.94772 19 10.5 19H13.5C14.0523 19 14.5 18.5523 14.5 18C14.5 17.4477 14.0523 17 13.5 17H10.5Z"
        fill="currentColor"
      />
    </svg>
  );
};
