import React, { ReactElement } from 'react';

// eslint-disable-next-line import/no-extraneous-dependencies
import { PartialNode } from '@react-stately/collections';
// eslint-disable-next-line import/no-extraneous-dependencies
import { SectionProps as BaseSectionProps } from '@react-types/shared';

interface SectionProps<T> extends BaseSectionProps<T> {
  disabled?: boolean;
}

export function Section<T>(_props: SectionProps<T>): ReactElement | null {
  return null;
}

Section.getCollectionNode = function* getCollectionNode<T>(
  props: SectionProps<T>,
): Generator<PartialNode<T>> {
  const { children, title, items } = props;

  yield {
    type: 'section',
    hasChildNodes: true,
    rendered: title,
    props: props,
    'aria-label': props['aria-label'],
    *childNodes() {
      if (typeof children === 'function') {
        if (!items) {
          throw new Error('props.children was a function but props.items is missing');
        }

        for (const item of items) {
          yield {
            type: 'item',
            value: item,
            renderer: children,
          };
        }
      } else {
        const items: PartialNode<T>[] = [];

        React.Children.forEach(children, (child) => {
          items.push({
            type: 'item',
            element: child,
          });
        });

        yield* items;
      }
    },
  };
};
