export interface RequestOptions {
  /**
   * Body for request.
   */
  body?: any;
  /**
   * Request method.
   */
  method?: 'GET' | 'POST' | 'DELETE' | 'PATCH' | 'PUT';
  /**
   * Signal from abort controller.
   */
  signal?: AbortSignal;
  /**
   * Query params.
   */
  query?: Record<string, any>;
}

export interface OkResponse<T> {
  /**
   * Response type.
   */
  type: 'success';
  /**
   * Response data.
   */
  data: T;
  /**
   * Response status.
   */
  status: number;
  /**
   * Sets true when request is canceled.
   */
  canceled?: boolean;
}
