import React, { FC, Key, useCallback } from 'react';

import type { NormalizedSuggestSection } from '../../shared/api';
import { Item, Section } from '../../shared/libs/collections';
import { SearchSuggestBase } from './SearchSuggestBase';
import type { LayoutProps } from './types';
import type { UseSuggestListResult } from './useSuggestList';

export interface SearchSuggestProps extends LayoutProps {
  list: UseSuggestListResult<NormalizedSuggestSection[]>;
}

export const SearchSuggest: FC<SearchSuggestProps> = (props) => {
  const { layout, scale, list } = props;

  const handleOnChange = useCallback((key: Key) => {
    window.location.href = String(key);
  }, []);

  const handleOnFocus = useCallback(() => {
    list.prefetch();
  }, [list]);

  return (
    <SearchSuggestBase
      aria-label="Поиск"
      inputValue={list.searchText}
      isError={list.isError}
      isLoading={list.isLoading}
      layout={layout}
      onFocus={handleOnFocus}
      onInputChange={list.setSearchText}
      onSelectionChange={handleOnChange}
      scale={scale}
    >
      {list.items.map((section) => (
        <Section
          key={section.searchUrl ?? section.source}
          disabled={!section.searchUrl}
          {...section}
        >
          {section.items.map((option) => (
            <Item key={option.searchUrl} {...option}>
              {option.title}
            </Item>
          ))}
        </Section>
      ))}
    </SearchSuggestBase>
  );
};
