/* eslint-disable @typescript-eslint/no-use-before-define */
import React from 'react';

import { Story } from '@storybook/react';
import { Provider, SearchSuggest, createApi, useSuggestList } from '@yandex-id/search-suggest';

import { paths, startFakeServer } from '../../../shared/api/fixtures';

startFakeServer();

const api = createApi({ suggestUrl: paths.suggest, searchUrl: paths.search });

export const Default: Story = () => {
  const list = useSuggestList(api);

  return (
    <Provider>
      <style>{styles}</style>
      <div className="x-desktop-header">
        <SearchSuggest list={list} />
      </div>
    </Provider>
  );
};

const styles = `
  body {
    padding: 0 !important;
    background-color: var(--id-color-surface-elevated-0);
  }

  .x-desktop-header {
    height: 80px;
    display: flex;
    align-items: center;
    justify-content: center;
  }

  .x-desktop-header .ID-Suggest {
    width: 520px;
  }
`;
