/* eslint-disable @typescript-eslint/no-use-before-define */
import React from 'react';

import { Story } from '@storybook/react';
import { Provider, SearchSuggest, createApi, useSuggestList } from '@yandex-id/search-suggest';

import { paths, startFakeServer } from '../../../shared/api/fixtures';

startFakeServer();

const api = createApi({ suggestUrl: paths.suggest, searchUrl: paths.search });

export const Touch: Story = () => {
  const list = useSuggestList(api);

  return (
    <Provider>
      <style>{styles}</style>
      <div className="x-touch-header">
        <SearchSuggest list={list} layout="fullscreen" scale="large" />
      </div>
    </Provider>
  );
};

const styles = `
  body {
    padding: 0 !important;
    background-color: var(--id-color-surface-elevated-0);
  }

  .x-touch-header {
    background-color: var(--id-color-surface-elevated-100);
    padding: 108px 16px 12px 16px;
  }
`;
