import React, { FC, useRef } from 'react';

import { SharedButtonProps, mergeProps, useButton, useHover } from '@use-platform/react';

import './FieldButton.css';

export const FieldButton: FC<SharedButtonProps> = (props) => {
  const { children } = props;
  const buttonRef = useRef<HTMLButtonElement>(null);
  const { isHovered, hoverProps } = useHover({});
  const { buttonProps } = useButton(props, buttonRef);

  return (
    <button
      {...mergeProps(buttonProps, hoverProps)}
      data-hovered={isHovered || undefined}
      className="ID-FieldButton"
    >
      {children}
    </button>
  );
};
