import React, { VFC } from 'react';

import { BrokenKind } from './BrokenKind';
import { NotFoundKind } from './NotFoundKind';

import './Informer.css';

type InformerKind = 'not-found' | 'broken';

interface InformerProps {
  kind: InformerKind;
}

export const Informer: VFC<InformerProps> = (props) => {
  const { kind } = props;

  if (process.env.NODE_ENV !== 'production') {
    // eslint-disable-next-line @typescript-eslint/no-use-before-define
    if (!kinds[kind]) {
      throw new Error(`Unexpected informer kind: ${kind}.`);
    }
  }

  // eslint-disable-next-line @typescript-eslint/no-use-before-define
  const Content = kinds[kind];

  return (
    <div className="ID-Informer">
      <Content />
    </div>
  );
};

const kinds: Record<InformerKind, VFC> = {
  'not-found': NotFoundKind,
  broken: BrokenKind,
};
