import React, { forwardRef, useRef } from 'react';
import { useListBox } from 'react-aria';
import type { ListState } from 'react-stately';

import { useForwardedRef } from '@use-platform/react';

import { ListGroup } from './ListGroup';

import './ListBox.css';

interface ListBoxProps {
  state: ListState<unknown>;
}

export const ListBox = forwardRef<HTMLDivElement, ListBoxProps>((props, forwardedRef) => {
  const { children, state, ...otherProps } = props;
  const ref = useRef<HTMLDivElement>(null);

  useForwardedRef(ref, forwardedRef);
  const { listBoxProps } = useListBox(otherProps, state, ref);

  return (
    <div {...listBoxProps} ref={ref} className="ID-ListBox">
      {[...state.collection].map((section: any) => (
        <ListGroup key={section.key} section={section} state={state} />
      ))}
    </div>
  );
});
