import React, { FC, useRef } from 'react';
import { useOption } from 'react-aria';
import type { ListState } from 'react-stately';

import type { NormalizedSuggestItem, NormalizedSuggestSection } from '../../../../shared/api';
import { ArrowShortForward } from '../../../../shared/icons';
import type { SectionProps } from '../../../../shared/libs/collections';
import { ListOption } from './ListOption';

interface ListGroupProps {
  section: SectionProps<NormalizedSuggestSection, NormalizedSuggestItem>;
  state: ListState<unknown>;
}

export const ListGroup: FC<ListGroupProps> = (props) => {
  const { section, state } = props;
  const ref = useRef<HTMLDivElement>(null);
  const { optionProps, isPressed, isFocused } = useOption(section, state, ref);

  return (
    <div className="ID-ListBox-Section">
      <div
        {...optionProps}
        className="ID-ListBox-SectionHeader"
        data-focused={isPressed || isFocused || undefined}
        ref={ref}
      >
        {section.props.source}
        {section.props.searchUrl && (
          <span className="ID-ListBox-SectionButton">
            Все <ArrowShortForward size={16} />
          </span>
        )}
      </div>
      {[...section.childNodes].map((option) => (
        <ListOption key={option.key} option={option} state={state} />
      ))}
    </div>
  );
};
