/* eslint-disable @typescript-eslint/no-use-before-define */
import React, { VFC } from 'react';

import './ListBoxSkeleton.css';

export const ListBoxSkeleton: VFC = () => {
  return (
    <div className="ID-ListBoxSkeleton">
      <SectionHeaderSkeleton />
      <ItemSkeleton />
      <ItemSkeleton isShort />
      <ItemSkeleton />
      <ItemSkeleton isShort />
    </div>
  );
};

const SectionHeaderSkeleton: VFC = () => {
  return (
    <svg viewBox="0 0 269 38" fill="none" className="ID-ListBoxSkeleton-Row">
      <rect x="12" y="15" width="76" height="12" rx="6" fill="currentColor" />
    </svg>
  );
};

const ItemSkeleton: VFC<{ isShort?: boolean }> = (props) => {
  const { isShort = false } = props;

  const path = isShort
    ? 'M20 25C24.4183 25 28 21.4183 28 17C28 12.5817 24.4183 9 20 9C15.5817 9 12 12.5817 12 17C12 21.4183 15.5817 25 20 25ZM50 11C46.6863 11 44 13.6863 44 17C44 20.3137 46.6863 23 50 23H158C161.314 23 164 20.3137 164 17C164 13.6863 161.314 11 158 11H50Z'
    : 'M20 25C24.4183 25 28 21.4183 28 17C28 12.5817 24.4183 9 20 9C15.5817 9 12 12.5817 12 17C12 21.4183 15.5817 25 20 25ZM50 11C46.6863 11 44 13.6863 44 17C44 20.3137 46.6863 23 50 23H198C201.314 23 204 20.3137 204 17C204 13.6863 201.314 11 198 11H50Z';

  return (
    <svg viewBox="0 0 269 34" fill="none" className="ID-ListBoxSkeleton-Row">
      <path fillRule="evenodd" clipRule="evenodd" d={path} fill="currentColor" />
    </svg>
  );
};
