import React, { ReactNode, RefObject, forwardRef, useEffect } from 'react';

import { useForkRef } from '@use-platform/react';
import { PopperAnyModifiers, applyMaxHeight, usePopper } from '@yandex-lego/components/usePopper';
import { usePreventScroll } from '@yandex-lego/components/usePreventScroll';

import './Popover.css';

interface PopoverProps {
  children: ReactNode;
  isVisible: boolean;
  offset?: number;
  shouldPreventScroll?: boolean;
  targetRef: RefObject<HTMLElement>;
}

export const Popover = forwardRef<HTMLDivElement, PopoverProps>((props, forwardedRef) => {
  const { children, targetRef, isVisible, shouldPreventScroll, offset } = props;
  const { setPopupRef } = usePopper({
    anchorRef: targetRef,
    enabled: isVisible,
    offset: [0, offset],
    // eslint-disable-next-line @typescript-eslint/no-use-before-define
    modifiers: MODIFIERS,
  });
  const ref = useForkRef(forwardedRef, setPopupRef);

  usePreventScroll({ enabled: shouldPreventScroll });

  // Don't use any dependencies for this effect for trigger on each updates.
  useEffect(() => {
    function onResize() {
      // Trigger resize event for avoid problem for ios.
      window.dispatchEvent(new Event('resize'));
    }

    visualViewport.addEventListener('resize', onResize);

    return () => {
      visualViewport.removeEventListener('resize', onResize);
    };
  });

  if (!isVisible) {
    return null;
  }

  return (
    <div ref={ref} className="ID-Popover">
      {children}
    </div>
  );
});

const MODIFIERS: PopperAnyModifiers = [
  {
    ...applyMaxHeight,
    options: {
      padding: 24,
    },
  },
];
