import { Key } from 'react';

// eslint-disable-next-line import/no-extraneous-dependencies
import { Collection, KeyboardDelegate, Node } from '@react-types/shared';

export class ListKeyboardDelegate<T> implements KeyboardDelegate {
  constructor(private collection: Collection<Node<T>>) {
    this.collection = collection;
  }

  getKeyBelow(key: Key) {
    // eslint-disable-next-line no-param-reassign
    key = this.collection.getKeyAfter(key) as Key;

    while (key !== null && key !== undefined) {
      const item = this.collection.getItem(key);

      if (!item.props.disabled) {
        return key;
      }

      // eslint-disable-next-line no-param-reassign
      key = this.collection.getKeyAfter(key) as Key;
    }

    return key;
  }

  getKeyAbove(key: Key) {
    // eslint-disable-next-line no-param-reassign
    key = this.collection.getKeyBefore(key) as Key;

    while (key !== null && key !== undefined) {
      const item = this.collection.getItem(key);

      if (!item.props.disabled) {
        return key;
      }

      // eslint-disable-next-line no-param-reassign
      key = this.collection.getKeyBefore(key) as Key;
    }

    return key;
  }

  getFirstKey() {
    let key = this.collection.getFirstKey() as Key;

    while (key !== null && key !== undefined) {
      const item = this.collection.getItem(key);

      if (!item.props.disabled) {
        return key;
      }

      key = this.collection.getKeyAfter(key) as Key;
    }

    return key;
  }

  getLastKey() {
    let key = this.collection.getLastKey() as Key;

    while (key !== null && key !== undefined) {
      const item = this.collection.getItem(key);

      if (!item.props.disabled) {
        return key;
      }

      key = this.collection.getKeyBefore(key) as Key;
    }

    return key;
  }
}
