import { useComboBoxState as useComboBoxStateBase } from 'react-stately';

// eslint-disable-next-line import/no-extraneous-dependencies
import { ComboBoxState, ComboBoxStateProps } from '@react-stately/combobox';

export function useComboBoxState<T extends object>(props: ComboBoxStateProps<T>): ComboBoxState<T> {
  const state = useComboBoxStateBase(props);

  // HACK: В react-aria элементы с типом section нельзя выбирать,
  // но в нашем случае section является интерактивной частью.
  for (const item of state.collection) {
    item.type = 'item';
  }

  return state;
}
