import { DynamicModule, Global, Module, Provider } from '@nestjs/common';

import { IPREG_OPTIONS } from './ipreg.constants';
import {
  IpregModuleAsyncOptions,
  IpregModuleOptions,
  IpregOptionsFactory,
} from './ipreg.interfaces';
import { IpregService } from './ipreg.service';

@Global()
@Module({
  imports: [],
  providers: [
    {
      provide: IPREG_OPTIONS,
      useValue: {},
    },
    IpregService,
  ],
  exports: [IpregService],
})
export class IpregModule {
  static forRoot(options: IpregModuleOptions): DynamicModule {
    return {
      module: IpregModule,
      global: true,
      providers: [{ provide: IPREG_OPTIONS, useValue: options }],
    };
  }

  static forRootAsync(options: IpregModuleAsyncOptions): DynamicModule {
    return {
      module: IpregModule,
      global: true,
      providers: this.createAsyncProviders(options),
    };
  }

  private static createAsyncProviders(options: IpregModuleAsyncOptions): Provider[] {
    const providers: Provider[] = [this.createAsyncOptionsProvider(options)];

    if (!options.useExisting && options.useClass) {
      providers.push({ provide: options.useClass, useClass: options.useClass });
    }

    return providers;
  }

  private static createAsyncOptionsProvider(options: IpregModuleAsyncOptions): Provider {
    const { useFactory, useExisting, useClass } = options;

    if (useFactory) {
      return {
        provide: IPREG_OPTIONS,
        useFactory,
      };
    }

    const dep = useExisting || useClass;

    if (dep) {
      return {
        provide: IPREG_OPTIONS,
        async useFactory(optionsFactory: IpregOptionsFactory) {
          return await optionsFactory.getOptions();
        },
        inject: [dep],
      };
    }

    throw new Error('Invalid configuration. Must provide useFactory, useClass or useExisting');
  }
}
