import { Inject, Injectable } from '@nestjs/common';
import { Context, StorageMemoize } from '@yandex-int/nest-common';

import { IpregController } from './ipreg';
import { IPREG_OPTIONS } from './ipreg.constants';
import { IpregModuleOptions } from './ipreg.interfaces';

@Injectable()
export class IpregService {
  private ipregController: IpregController | undefined;

  constructor(
    @Inject(IPREG_OPTIONS) private options: IpregModuleOptions,
    private context: Context,
  ) {
    if (!this.options.disabled) {
      this.ipregController = new IpregController(this.options.dbPath);
    }
  }

  @StorageMemoize()
  isYandexNet() {
    if (this.options.disabled) {
      return true;
    }

    if (!this.ipregController) {
      throw new Error('Wrong ipreg module configuration');
    }

    return this.ipregController.isYandexAddr(this.context.req.ip);
  }

  @StorageMemoize()
  isUserNet() {
    if (this.options.disabled) {
      return true;
    }

    if (!this.ipregController) {
      throw new Error('Wrong ipreg module configuration');
    }

    return this.ipregController.isUserAddr(this.context.req.ip);
  }
}
