import type { Command } from '@oclif/command';
import { exec, getBaseCommitInTrunk } from '@yandex-int/frontend.ci.utils';

import { ENV } from '../env';
import { ToolchainVCS } from './interface';

export class Git implements ToolchainVCS {
  private log: Command['log'];
  private branchCommit: string;
  constructor(logger: Command['log']) {
    this.log = logger;
    this.branchCommit = exec('git rev-parse HEAD');
  }

  commitChangedFiles(info: string) {
    const changedFiles = exec('git status -s').split('\n').filter(Boolean);

    if (changedFiles.length) {
      this.log(`${changedFiles}`);
      exec('git add .');
      exec(`git commit --no-verify -m '${ENV.AUTOCOMMIT}' -m '${info}' `);
      exec('git show HEAD', undefined, undefined, true);
    }
  }

  login() {
    this.log('git login');
    exec(`git config user.name ${ENV.ROBOT.NAME}`, undefined, undefined, true);
    exec(`git config user.email ${ENV.ROBOT.EMAIL}`, undefined, undefined, true);
  }

  reset() {
    exec('git reset --hard');
  }

  resetToTrunk() {
    exec(`git reset --soft ${getBaseCommitInTrunk()}`);
  }

  returnToBrach() {
    exec(`git checkout ${this.branchCommit}`);
  }

  async forcePush(baseBranch = 'master') {
    exec(`git push origin ${baseBranch} --no-verify`, undefined, undefined, true);
  }
}
