import type { Command } from '@oclif/command';
import { isArcWorkTreeSync, isGitWorkTreeSync } from '@yandex-int/si.ci.is-vcs-work-tree';

import { Arc } from './arc';
import { Git } from './git';
import { ToolchainVCS } from './interface';

export function getVcs(logger: Command['log']): ToolchainVCS {
  if (isGitWorkTreeSync(process.cwd())) {
    return new Git(logger);
  }

  if (isArcWorkTreeSync(process.cwd())) {
    return new Arc(logger);
  }
  throw new Error('Не могу определить VCS');
}
