(async function() {
    try {
        const got = require('got');

        const eventUrl = 'https://api.github.yandex-team.ru/repos/passport-frontend/id-frontend/events?per_page=100';

        console.debug('Checkout config', process.env.checkout_config);
        const headCommit = JSON.parse(process.env.checkout_config).head.commit;

        console.debug('Head commit', headCommit);

        const events = await (got(eventUrl).json());

        const pushEvents = events.filter(event =>
            event.type === 'PushEvent' &&
            event.actor.login === 'robot-merge-queue'
        )

        console.debug('Robot pushed events ', pushEvents.map(event => event.payload));

        if (pushEvents.some(event => event.payload.head === headCommit)) {
            console.debug('Current commit is pushed by robot-merge-queue');
            process.exit(0)
        }

        console.debug('Current commit is NOT pushed by robot-merge-queue');
        process.exit(1);
        // если что-то пошло не так, то всегда игнорируем это
    } catch (e) {
        console.debug('Error', e);
        process.exit(1)
    }
})();
