#!/usr/bin/env node
/* eslint-disable no-console */

process.env.SANDBOX_OAUTH_TOKEN = process.env.SANDBOX_AUTH_TOKEN;

const fs = require('fs');
const path = require('path');
const got = require('got');
const { Affected } = require('@yandex-lego/iver');

const PR_NUMBER = process.env.TRENDBOX_PULL_REQUEST_NUMBER;

const PR_DESCRIPTION_UPDATE_URL = [
  'https://prosperity.si.yandex-team.ru/v1/sandbox/update-pull-request-description',
  '?configPath=.config/pr-description.yml',
  `&sectionId=selective`,
  `&prNumber=${PR_NUMBER}`,
].join('');

function getPayload(prNumber, affectedServices) {
  return {
    status: 'SUCCESS',
    id: 'fake-frontend-sandbox-payload',
    type: 'FAKE_PAYLOAD',
    output: [],
    custom_fields: [
      {
        name: 'project_github_owner',
        value: 'passport-frontend',
      },
      {
        name: 'project_github_repo',
        value: 'id-frontend',
      },
      {
        name: 'pull_request_number',
        value: prNumber,
      },
      {
        name: 'arcanum_review_request_id',
        value: prNumber,
      },
      {
        name: 'affected_services',
        value: affectedServices,
      },
    ],
  };
}

function getDescriptionForAffectedPackages(paths) {
  return paths.reduce((configs, packagePath) => {
    const descriptionConfigPath = path.join(packagePath, '.config/pr-description-config.js');

    if (fs.existsSync(descriptionConfigPath)) {
      const descriptionConfig = require(descriptionConfigPath);

      return configs.concat(descriptionConfig);
    }

    return configs;
  }, []);
}

function sendRequest(url, payload) {
  return got
    .post(url, { json: payload, response: 'json' })
    .then(({ body }) => console.log(body))
    .catch((e) => {
      console.error(e.stack || e);
      process.exit(1);
    });
}

async function getAffectedPackagesPaths() {
  const command = new Affected({ vcs: {} });
  const result = await command.execute();
  const packagePaths = result.sortedAffectedPackages.map((_package) => _package.location);

  return packagePaths;
}

(async function () {
  const affectedPackagesPaths = await getAffectedPackagesPaths();
  const prUpdateConfig = getDescriptionForAffectedPackages(affectedPackagesPaths);
  const prUpdatePayload = getPayload(PR_NUMBER, prUpdateConfig.reverse());

  console.log(`Request: ${PR_DESCRIPTION_UPDATE_URL} Payload: ${JSON.stringify(prUpdatePayload)}`);

  await sendRequest(PR_DESCRIPTION_UPDATE_URL, prUpdatePayload);
})();

//prosperity.si.yandex-team.ru/v1/sandbox/update-pull-request-description?configPath=.config/pr-description.yml&sectionId=selective&prNumber=2473680 Payload:

t = {
  status: 'SUCCESS',
  id: 'fake-frontend-sandbox-payload',
  type: 'FAKE_PAYLOAD',
  output: [],
  custom_fields: [
    {
      name: 'project_github_owner',
      value: 'passport-frontend',
    },
    {
      name: 'project_github_repo',
      value: 'id-frontend',
    },
    {
      name: 'arcanum_review_request_id',
      value: '2473680',
    },
    {
      name: 'affected_services',
      value: [
        {
          service: 'Y.Deploy',
          '@title': 'Y.Deploy - Yandex.ID',
          '@iconUrl': 'https://github.yandex-team.ru/images/icons/emoji/unicode/1f680.png',
          pipeLinks: [
            {
              label: 'Автобета',
              url: 'https://pr-id-{{github_payload.pull_request.number}}.beta.ohio-www.yandex.ru/',
              qr: true,
            },
            {
              label: 'Стейдж',
              url: 'https://deploy.yandex-team.ru/stages/pr-id-{{github_payload.pull_request.number}}_ohio-www',
            },
          ],
        },
      ],
    },
  ],
};
