require('dotenv').config();

const { NestServer } = require('../components/nest-server');
const { TvmDaemon } = require('../components/tvm-daemon');
const { SshPortForwarding } = require('../components/ssh-port-forwarding');
const { GraphqlGenerator } = require('../components/graphql-generator');

/**
 * @type {import('@yandex-int/archon/src/command').Command}
 */
module.exports = {
  name: 'dev',
  description: 'Запускает dev-окружение',
  graph: () => [
    new TvmDaemon(),
    new SshPortForwarding({
      options: {
        host: 'python-dev2.passport.yandex.net',
        forwardingPorts: [
          {
            host: 'passport-test-internal.yandex.ru',
            port: '8080',
            hostPort: '80',
          },
          {
            host: 'oauth-test-internal.yandex.ru',
            port: '8081',
            hostPort: '80',
          },
          {
            host: 'localhost',
            port: '8082',
            hostPort: '6000',
          },
        ],
      },
    }),
    new GraphqlGenerator(),
    new NestServer({ deps: [GraphqlGenerator.token] }),
  ],
};
