const { Cmd } = require('../../../../../.config/archon/components/cmd');

class NestServer extends Cmd {
  static token = 'nest-server';

  constructor({ deps }) {
    super({
      name: NestServer.token,
      deps,
      options: {
        cmd: 'nest',
        async: true,
        asyncWait: 10000,
        args: [
          'build',
          '--path',
          'tsconfig.server.json',
          '--webpack',
          '--webpackPath',
          'webpack-hmr.config.js',
          '--watch',
        ],
      },
    });
  }
}

module.exports = { NestServer };
