const { DOCKER_TOKEN, DCTL_YP_TOKEN, ROBOT_AWACS_TOKEN, ROBOT_CI_LOGIN, ACCESS_KEY_ID, SECRET_ACCESS_KEY } = process.env;

module.exports = {
  scripts: {
    'create-beta': {
      workflow: 'createBeta',
      configPath: '.config/deploy/config.beta.yml',
      environment: 'beta',
      slug: `pr-id-${process.env.TRENDBOX_PULL_REQUEST_NUMBER}`,
    },
    'remove-beta': {
      workflow: 'removeBeta',
      configPath: '.config/deploy/config.beta.yml',
      environment: 'beta',
      slug: `pr-id-${process.env.TRENDBOX_PULL_REQUEST_NUMBER}`,
    },
    master: {
      workflow: 'createBeta',
      configPath: '.config/deploy/config.beta.yml',
      environment: 'testing',
      slug: 'id-master',
    },
  },
  options: {
    login: ROBOT_CI_LOGIN,
    dctlToken: DCTL_YP_TOKEN,
    awacsToken: ROBOT_AWACS_TOKEN,
    yavLogin: ROBOT_CI_LOGIN,
    docker: {
      registry: 'registry.yandex.net',
      repository: 'mail/ohio/frontend',
      login: ROBOT_CI_LOGIN,
      oauthToken: DOCKER_TOKEN,
      buildArgs: [],
    },
    s3: {
      accessKeyId: ACCESS_KEY_ID,
      secretAccessKey: SECRET_ACCESS_KEY,
    }
  }
};
