const { toId } = require('@storybook/csf');
const { buildArgsParam } = require('@storybook/router');

module.exports = async function yaOpenStory(id, storyName, params) {
  if (!id) {
    throw new TypeError('Invalid parameter: id');
  }

  if (!storyName) {
    throw new TypeError('Invalid parameter: storyName');
  }

  const story = toId(id, storyName);
  let args = {};

  if (params) {
    args = Object.entries(params).reduce((acc, [key, value]) => {
      acc[key] = buildArgsParam({}, value);

      return acc;
    }, {});
  }

  const searchParams = new URLSearchParams(Object.assign(
    {
      id: story,
      viewMode: 'story',
    },
    args
  ));

  await this.url('/storybook/iframe.html?' + searchParams);

  // ждём загрузки шрифтов
  return this.executeAsync(function(done) {
    if (!document.fonts) {
        return done();
    }
    return document.fonts.ready.then(function() {
      done();
    });
  });
};
